<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Forms;

class Video extends \Google\Model
{
  protected $propertiesType = MediaProperties::class;
  protected $propertiesDataType = '';
  public $properties;
  /**
   * @var string
   */
  public $youtubeUri;

  /**
   * @param MediaProperties
   */
  public function setProperties(MediaProperties $properties)
  {
    $this->properties = $properties;
  }
  /**
   * @return MediaProperties
   */
  public function getProperties()
  {
    return $this->properties;
  }
  /**
   * @param string
   */
  public function setYoutubeUri($youtubeUri)
  {
    $this->youtubeUri = $youtubeUri;
  }
  /**
   * @return string
   */
  public function getYoutubeUri()
  {
    return $this->youtubeUri;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Video::class, 'Google_Service_Forms_Video');
